//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

	float AuroraNoise(vec2 coord,vec2 wind,float cosT ){
	float noise = texture2D(noisetex, coord * 0.0625  + wind * 0.25).b * 3.0;
		  noise+= texture2D(noisetex, coord * 0.03125 + wind * 0.15).b * 3.0;
		  noise = max(1.0 - 4.0 * (0.5 * cosT + 0.5) * abs(noise - 3.0), 0.0);

	return noise;
}

vec3 DrawAurora(vec3 viewPos,float dither,int sampleCount){
	
	#if AA>1
	dither=fract(16.*frameTimeCounter+dither);
	#endif
	
	float gradientMix=dither/sampleCount;
	float cosT=dot(normalize(viewPos),upVec);

	float visibility=(1.-rainStrengthS)*(1.-rainStrengthS);
	#ifndef END
	visibility *= moonVisibility;
	#endif
	
	#ifndef AURORA_WEATHER_PERBIOME
	visibility *= isCold * isCold;
	#endif

	vec2 wind=vec2(
		frameTimeCounter*CLOUD_SPEED*.000125,
		sin(frameTimeCounter*CLOUD_SPEED*.05)*.00025
	);
	
	vec3 aurora=vec3(0.);
	
	if(cosT>0.&&visibility>0.){
		vec3 wpos=normalize((gbufferModelViewInverse*vec4(viewPos,1.)).xyz);
		for(int i=0;i<sampleCount;i++){
			vec3 planeCoord=wpos*((AURORA_DISTANCE+(i+dither)*AURORA_SIZE/sampleCount)/wpos.y)*.004;
			vec2 coord=cameraPosition.xz*.00004+planeCoord.xz;
			coord+=vec2(coord.y,-coord.x)*.3;
			
			float noise=AuroraNoise(coord,wind,cosT);
			
			if(noise>0.){
				noise*=texture2D(noisetex,coord*.125+wind*.25).b;
				noise*=.5*texture2D(noisetex,coord+wind*16.).b+.75;
				noise=noise*noise*3./sampleCount;
				noise*=max(sqrt(1.-length(planeCoord.xz)*3.75),0.);
				
				#if AURORA_COLOR == 1
				vec3 auroraColor=mix(
					vec3(.1,1.,.5),
					vec3(0.3451, 0.0, 0.4118),
					pow(gradientMix,.4)
				);
				#endif
				#if AURORA_COLOR == 2
				vec3 auroraColor=mix(
					vec3(.1,1.,.5),
					vec3(0.0, 0.0, 0.7216),
					pow(gradientMix,.4)
				);
				#endif
				#if AURORA_COLOR == 3
				vec3 auroraColor=mix(
					vec3(.1,1.,.5),
					vec3(0.6667, 0.0, 0.0),
					pow(gradientMix,.4)
				);
				#endif
				#if AURORA_COLOR == 4
				vec3 auroraColor=mix(
					vec3(.1,1.,.5),
					vec3(0.6157, 0.6275, 0.0),
					pow(gradientMix,.4)
				);
				#endif
				#if AURORA_COLOR == 5
				vec3 auroraColor=mix(
					hue(frameTimeCounter * RAINBOW_COLOR_AURORA_1_SPEED + RAINBOW_COLOR_AURORA_1_START),
					hue(frameTimeCounter * RAINBOW_COLOR_AURORA_2_SPEED + RAINBOW_COLOR_AURORA_2_START),
					pow(gradientMix,.4)
				);
				#endif

				aurora += noise* auroraColor*exp2(-6.0*i/sampleCount)*AURORA_VISIBILITY;
				aurora *= 1.0 - exp(- (10.0 - 9.0 * rainStrengthS) * cosT) ;
			}
			gradientMix+=1.0/sampleCount;
		}
	}
	
	return aurora*visibility;
}